// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> Failover policy of the read-write endpoint for the failover group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required. </summary>
    public readonly partial struct ReadWriteEndpointFailoverPolicy : IEquatable<ReadWriteEndpointFailoverPolicy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ReadWriteEndpointFailoverPolicy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ReadWriteEndpointFailoverPolicy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ManualValue = "Manual";
        private const string AutomaticValue = "Automatic";

        /// <summary> Manual. </summary>
        public static ReadWriteEndpointFailoverPolicy Manual { get; } = new ReadWriteEndpointFailoverPolicy(ManualValue);
        /// <summary> Automatic. </summary>
        public static ReadWriteEndpointFailoverPolicy Automatic { get; } = new ReadWriteEndpointFailoverPolicy(AutomaticValue);
        /// <summary> Determines if two <see cref="ReadWriteEndpointFailoverPolicy"/> values are the same. </summary>
        public static bool operator ==(ReadWriteEndpointFailoverPolicy left, ReadWriteEndpointFailoverPolicy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ReadWriteEndpointFailoverPolicy"/> values are not the same. </summary>
        public static bool operator !=(ReadWriteEndpointFailoverPolicy left, ReadWriteEndpointFailoverPolicy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ReadWriteEndpointFailoverPolicy"/>. </summary>
        public static implicit operator ReadWriteEndpointFailoverPolicy(string value) => new ReadWriteEndpointFailoverPolicy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ReadWriteEndpointFailoverPolicy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ReadWriteEndpointFailoverPolicy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
