// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> Failover policy of the read-only endpoint for the failover group. </summary>
    public readonly partial struct ReadOnlyEndpointFailoverPolicy : IEquatable<ReadOnlyEndpointFailoverPolicy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ReadOnlyEndpointFailoverPolicy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ReadOnlyEndpointFailoverPolicy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string EnabledValue = "Enabled";

        /// <summary> Disabled. </summary>
        public static ReadOnlyEndpointFailoverPolicy Disabled { get; } = new ReadOnlyEndpointFailoverPolicy(DisabledValue);
        /// <summary> Enabled. </summary>
        public static ReadOnlyEndpointFailoverPolicy Enabled { get; } = new ReadOnlyEndpointFailoverPolicy(EnabledValue);
        /// <summary> Determines if two <see cref="ReadOnlyEndpointFailoverPolicy"/> values are the same. </summary>
        public static bool operator ==(ReadOnlyEndpointFailoverPolicy left, ReadOnlyEndpointFailoverPolicy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ReadOnlyEndpointFailoverPolicy"/> values are not the same. </summary>
        public static bool operator !=(ReadOnlyEndpointFailoverPolicy left, ReadOnlyEndpointFailoverPolicy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ReadOnlyEndpointFailoverPolicy"/>. </summary>
        public static implicit operator ReadOnlyEndpointFailoverPolicy(string value) => new ReadOnlyEndpointFailoverPolicy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ReadOnlyEndpointFailoverPolicy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ReadOnlyEndpointFailoverPolicy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
