// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> Properties of a query execution statistics. </summary>
    public partial class QueryStatisticsProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="QueryStatisticsProperties"/>. </summary>
        internal QueryStatisticsProperties()
        {
            Intervals = new ChangeTrackingList<QueryMetricInterval>();
        }

        /// <summary> Initializes a new instance of <see cref="QueryStatisticsProperties"/>. </summary>
        /// <param name="databaseName"> Database name of the database in which this query was executed. </param>
        /// <param name="queryId"> Unique query id (unique within one database). </param>
        /// <param name="startTime"> The start time for the metric (ISO-8601 format). </param>
        /// <param name="endTime"> The end time for the metric (ISO-8601 format). </param>
        /// <param name="intervals"> List of intervals with appropriate metric data. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal QueryStatisticsProperties(string databaseName, string queryId, string startTime, string endTime, IReadOnlyList<QueryMetricInterval> intervals, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DatabaseName = databaseName;
            QueryId = queryId;
            StartTime = startTime;
            EndTime = endTime;
            Intervals = intervals;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Database name of the database in which this query was executed. </summary>
        [WirePath("databaseName")]
        public string DatabaseName { get; }
        /// <summary> Unique query id (unique within one database). </summary>
        [WirePath("queryId")]
        public string QueryId { get; }
        /// <summary> The start time for the metric (ISO-8601 format). </summary>
        [WirePath("startTime")]
        public string StartTime { get; }
        /// <summary> The end time for the metric (ISO-8601 format). </summary>
        [WirePath("endTime")]
        public string EndTime { get; }
        /// <summary> List of intervals with appropriate metric data. </summary>
        [WirePath("intervals")]
        public IReadOnlyList<QueryMetricInterval> Intervals { get; }
    }
}
