// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Sql.Models
{
    public partial class QueryMetricInterval : IUtf8JsonSerializable, IJsonModel<QueryMetricInterval>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<QueryMetricInterval>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<QueryMetricInterval>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<QueryMetricInterval>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(QueryMetricInterval)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(IntervalStartTime))
            {
                writer.WritePropertyName("intervalStartTime"u8);
                writer.WriteStringValue(IntervalStartTime);
            }
            if (options.Format != "W" && Optional.IsDefined(IntervalType))
            {
                writer.WritePropertyName("intervalType"u8);
                writer.WriteStringValue(IntervalType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ExecutionCount))
            {
                writer.WritePropertyName("executionCount"u8);
                writer.WriteNumberValue(ExecutionCount.Value);
            }
            if (Optional.IsCollectionDefined(Metrics))
            {
                writer.WritePropertyName("metrics"u8);
                writer.WriteStartArray();
                foreach (var item in Metrics)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        QueryMetricInterval IJsonModel<QueryMetricInterval>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<QueryMetricInterval>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(QueryMetricInterval)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeQueryMetricInterval(document.RootElement, options);
        }

        internal static QueryMetricInterval DeserializeQueryMetricInterval(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string intervalStartTime = default;
            QueryTimeGrainType? intervalType = default;
            long? executionCount = default;
            IList<QueryMetricProperties> metrics = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("intervalStartTime"u8))
                {
                    intervalStartTime = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("intervalType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    intervalType = new QueryTimeGrainType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("executionCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    executionCount = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("metrics"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<QueryMetricProperties> array = new List<QueryMetricProperties>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(QueryMetricProperties.DeserializeQueryMetricProperties(item, options));
                    }
                    metrics = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new QueryMetricInterval(intervalStartTime, intervalType, executionCount, metrics ?? new ChangeTrackingList<QueryMetricProperties>(), serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IntervalStartTime), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  intervalStartTime: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IntervalStartTime))
                {
                    builder.Append("  intervalStartTime: ");
                    if (IntervalStartTime.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{IntervalStartTime}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{IntervalStartTime}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IntervalType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  intervalType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IntervalType))
                {
                    builder.Append("  intervalType: ");
                    builder.AppendLine($"'{IntervalType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ExecutionCount), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  executionCount: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ExecutionCount))
                {
                    builder.Append("  executionCount: ");
                    builder.AppendLine($"'{ExecutionCount.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Metrics), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  metrics: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Metrics))
                {
                    if (Metrics.Any())
                    {
                        builder.Append("  metrics: ");
                        builder.AppendLine("[");
                        foreach (var item in Metrics)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  metrics: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<QueryMetricInterval>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<QueryMetricInterval>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(QueryMetricInterval)} does not support writing '{options.Format}' format.");
            }
        }

        QueryMetricInterval IPersistableModel<QueryMetricInterval>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<QueryMetricInterval>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeQueryMetricInterval(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(QueryMetricInterval)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<QueryMetricInterval>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
