// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> Partner region information for the failover group. </summary>
    public partial class PartnerRegionInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PartnerRegionInfo"/>. </summary>
        public PartnerRegionInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PartnerRegionInfo"/>. </summary>
        /// <param name="location"> Geo location of the partner managed instances. </param>
        /// <param name="replicationRole"> Replication role of the partner managed instances. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PartnerRegionInfo(AzureLocation? location, InstanceFailoverGroupReplicationRole? replicationRole, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Location = location;
            ReplicationRole = replicationRole;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Geo location of the partner managed instances. </summary>
        [WirePath("location")]
        public AzureLocation? Location { get; set; }
        /// <summary> Replication role of the partner managed instances. </summary>
        [WirePath("replicationRole")]
        public InstanceFailoverGroupReplicationRole? ReplicationRole { get; }
    }
}
