// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The units that the limit is expressed in. </summary>
    public readonly partial struct MaxSizeUnit : IEquatable<MaxSizeUnit>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MaxSizeUnit"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MaxSizeUnit(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MegabytesValue = "Megabytes";
        private const string GigabytesValue = "Gigabytes";
        private const string TerabytesValue = "Terabytes";
        private const string PetabytesValue = "Petabytes";

        /// <summary> Megabytes. </summary>
        public static MaxSizeUnit Megabytes { get; } = new MaxSizeUnit(MegabytesValue);
        /// <summary> Gigabytes. </summary>
        public static MaxSizeUnit Gigabytes { get; } = new MaxSizeUnit(GigabytesValue);
        /// <summary> Terabytes. </summary>
        public static MaxSizeUnit Terabytes { get; } = new MaxSizeUnit(TerabytesValue);
        /// <summary> Petabytes. </summary>
        public static MaxSizeUnit Petabytes { get; } = new MaxSizeUnit(PetabytesValue);
        /// <summary> Determines if two <see cref="MaxSizeUnit"/> values are the same. </summary>
        public static bool operator ==(MaxSizeUnit left, MaxSizeUnit right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MaxSizeUnit"/> values are not the same. </summary>
        public static bool operator !=(MaxSizeUnit left, MaxSizeUnit right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MaxSizeUnit"/>. </summary>
        public static implicit operator MaxSizeUnit(string value) => new MaxSizeUnit(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MaxSizeUnit other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MaxSizeUnit other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
