// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary>
    /// Specifies the mode of database creation.
    ///
    /// Default: Regular instance creation.
    ///
    /// Restore: Creates an instance by restoring a set of backups to specific point in time. RestorePointInTime and SourceManagedInstanceId must be specified.
    /// </summary>
    public readonly partial struct ManagedServerCreateMode : IEquatable<ManagedServerCreateMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedServerCreateMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedServerCreateMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "Default";
        private const string PointInTimeRestoreValue = "PointInTimeRestore";

        /// <summary> Default. </summary>
        public static ManagedServerCreateMode Default { get; } = new ManagedServerCreateMode(DefaultValue);
        /// <summary> PointInTimeRestore. </summary>
        public static ManagedServerCreateMode PointInTimeRestore { get; } = new ManagedServerCreateMode(PointInTimeRestoreValue);
        /// <summary> Determines if two <see cref="ManagedServerCreateMode"/> values are the same. </summary>
        public static bool operator ==(ManagedServerCreateMode left, ManagedServerCreateMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedServerCreateMode"/> values are not the same. </summary>
        public static bool operator !=(ManagedServerCreateMode left, ManagedServerCreateMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedServerCreateMode"/>. </summary>
        public static implicit operator ManagedServerCreateMode(string value) => new ManagedServerCreateMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedServerCreateMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedServerCreateMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
