// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The managed instance virtual cores capability. </summary>
    public partial class ManagedInstanceVcoresCapability
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ManagedInstanceVcoresCapability"/>. </summary>
        internal ManagedInstanceVcoresCapability()
        {
            SupportedStorageSizes = new ChangeTrackingList<MaxSizeRangeCapability>();
            SupportedMaintenanceConfigurations = new ChangeTrackingList<ManagedInstanceMaintenanceConfigurationCapability>();
        }

        /// <summary> Initializes a new instance of <see cref="ManagedInstanceVcoresCapability"/>. </summary>
        /// <param name="name"> The virtual cores identifier. </param>
        /// <param name="value"> The virtual cores value. </param>
        /// <param name="includedMaxSize"> Included size. </param>
        /// <param name="supportedStorageSizes"> Storage size ranges. </param>
        /// <param name="isInstancePoolSupported"> True if this service objective is supported for managed instances in an instance pool. </param>
        /// <param name="isStandaloneSupported"> True if this service objective is supported for standalone managed instances. </param>
        /// <param name="supportedMaintenanceConfigurations"> List of supported maintenance configurations. </param>
        /// <param name="status"> The status of the capability. </param>
        /// <param name="reason"> The reason for the capability not being available. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ManagedInstanceVcoresCapability(string name, int? value, MaxSizeCapability includedMaxSize, IReadOnlyList<MaxSizeRangeCapability> supportedStorageSizes, bool? isInstancePoolSupported, bool? isStandaloneSupported, IReadOnlyList<ManagedInstanceMaintenanceConfigurationCapability> supportedMaintenanceConfigurations, SqlCapabilityStatus? status, string reason, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Value = value;
            IncludedMaxSize = includedMaxSize;
            SupportedStorageSizes = supportedStorageSizes;
            IsInstancePoolSupported = isInstancePoolSupported;
            IsStandaloneSupported = isStandaloneSupported;
            SupportedMaintenanceConfigurations = supportedMaintenanceConfigurations;
            Status = status;
            Reason = reason;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The virtual cores identifier. </summary>
        [WirePath("name")]
        public string Name { get; }
        /// <summary> The virtual cores value. </summary>
        [WirePath("value")]
        public int? Value { get; }
        /// <summary> Included size. </summary>
        [WirePath("includedMaxSize")]
        public MaxSizeCapability IncludedMaxSize { get; }
        /// <summary> Storage size ranges. </summary>
        [WirePath("supportedStorageSizes")]
        public IReadOnlyList<MaxSizeRangeCapability> SupportedStorageSizes { get; }
        /// <summary> True if this service objective is supported for managed instances in an instance pool. </summary>
        [WirePath("instancePoolSupported")]
        public bool? IsInstancePoolSupported { get; }
        /// <summary> True if this service objective is supported for standalone managed instances. </summary>
        [WirePath("standaloneSupported")]
        public bool? IsStandaloneSupported { get; }
        /// <summary> List of supported maintenance configurations. </summary>
        [WirePath("supportedMaintenanceConfigurations")]
        public IReadOnlyList<ManagedInstanceMaintenanceConfigurationCapability> SupportedMaintenanceConfigurations { get; }
        /// <summary> The status of the capability. </summary>
        [WirePath("status")]
        public SqlCapabilityStatus? Status { get; }
        /// <summary> The reason for the capability not being available. </summary>
        [WirePath("reason")]
        public string Reason { get; }
    }
}
