// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The ManagedInstanceStartStopScheduleName. </summary>
    public readonly partial struct ManagedInstanceStartStopScheduleName : IEquatable<ManagedInstanceStartStopScheduleName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedInstanceStartStopScheduleName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedInstanceStartStopScheduleName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "default";

        /// <summary> default. </summary>
        public static ManagedInstanceStartStopScheduleName Default { get; } = new ManagedInstanceStartStopScheduleName(DefaultValue);
        /// <summary> Determines if two <see cref="ManagedInstanceStartStopScheduleName"/> values are the same. </summary>
        public static bool operator ==(ManagedInstanceStartStopScheduleName left, ManagedInstanceStartStopScheduleName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedInstanceStartStopScheduleName"/> values are not the same. </summary>
        public static bool operator !=(ManagedInstanceStartStopScheduleName left, ManagedInstanceStartStopScheduleName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedInstanceStartStopScheduleName"/>. </summary>
        public static implicit operator ManagedInstanceStartStopScheduleName(string value) => new ManagedInstanceStartStopScheduleName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedInstanceStartStopScheduleName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedInstanceStartStopScheduleName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
