// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> Connection type used for connecting to the instance. </summary>
    public readonly partial struct ManagedInstanceProxyOverride : IEquatable<ManagedInstanceProxyOverride>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedInstanceProxyOverride"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedInstanceProxyOverride(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ProxyValue = "Proxy";
        private const string RedirectValue = "Redirect";
        private const string DefaultValue = "Default";

        /// <summary> Proxy. </summary>
        public static ManagedInstanceProxyOverride Proxy { get; } = new ManagedInstanceProxyOverride(ProxyValue);
        /// <summary> Redirect. </summary>
        public static ManagedInstanceProxyOverride Redirect { get; } = new ManagedInstanceProxyOverride(RedirectValue);
        /// <summary> Default. </summary>
        public static ManagedInstanceProxyOverride Default { get; } = new ManagedInstanceProxyOverride(DefaultValue);
        /// <summary> Determines if two <see cref="ManagedInstanceProxyOverride"/> values are the same. </summary>
        public static bool operator ==(ManagedInstanceProxyOverride left, ManagedInstanceProxyOverride right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedInstanceProxyOverride"/> values are not the same. </summary>
        public static bool operator !=(ManagedInstanceProxyOverride left, ManagedInstanceProxyOverride right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedInstanceProxyOverride"/>. </summary>
        public static implicit operator ManagedInstanceProxyOverride(string value) => new ManagedInstanceProxyOverride(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedInstanceProxyOverride other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedInstanceProxyOverride other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
