// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The parameters of a managed instance operation. </summary>
    public partial class ManagedInstanceOperationParametersPair
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ManagedInstanceOperationParametersPair"/>. </summary>
        internal ManagedInstanceOperationParametersPair()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ManagedInstanceOperationParametersPair"/>. </summary>
        /// <param name="currentParameters"> The current parameters. </param>
        /// <param name="requestedParameters"> The requested parameters. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ManagedInstanceOperationParametersPair(UpsertManagedServerOperationParameters currentParameters, UpsertManagedServerOperationParameters requestedParameters, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CurrentParameters = currentParameters;
            RequestedParameters = requestedParameters;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The current parameters. </summary>
        [WirePath("currentParameters")]
        public UpsertManagedServerOperationParameters CurrentParameters { get; }
        /// <summary> The requested parameters. </summary>
        [WirePath("requestedParameters")]
        public UpsertManagedServerOperationParameters RequestedParameters { get; }
    }
}
