// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The Transaction Manager Communication Settings of managed instance DTC. </summary>
    public partial class ManagedInstanceDtcTransactionManagerCommunicationSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ManagedInstanceDtcTransactionManagerCommunicationSettings"/>. </summary>
        public ManagedInstanceDtcTransactionManagerCommunicationSettings()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ManagedInstanceDtcTransactionManagerCommunicationSettings"/>. </summary>
        /// <param name="allowInboundEnabled"> Allow Inbound traffic to managed instance DTC. </param>
        /// <param name="allowOutboundEnabled"> Allow Outbound traffic of managed instance DTC. </param>
        /// <param name="authentication"> Authentication type of managed instance DTC. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ManagedInstanceDtcTransactionManagerCommunicationSettings(bool? allowInboundEnabled, bool? allowOutboundEnabled, string authentication, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AllowInboundEnabled = allowInboundEnabled;
            AllowOutboundEnabled = allowOutboundEnabled;
            Authentication = authentication;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Allow Inbound traffic to managed instance DTC. </summary>
        [WirePath("allowInboundEnabled")]
        public bool? AllowInboundEnabled { get; set; }
        /// <summary> Allow Outbound traffic of managed instance DTC. </summary>
        [WirePath("allowOutboundEnabled")]
        public bool? AllowOutboundEnabled { get; set; }
        /// <summary> Authentication type of managed instance DTC. </summary>
        [WirePath("authentication")]
        public string Authentication { get; set; }
    }
}
