// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> Status of the database. </summary>
    public readonly partial struct ManagedDatabaseStatus : IEquatable<ManagedDatabaseStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedDatabaseStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedDatabaseStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OnlineValue = "Online";
        private const string OfflineValue = "Offline";
        private const string ShutdownValue = "Shutdown";
        private const string CreatingValue = "Creating";
        private const string InaccessibleValue = "Inaccessible";
        private const string RestoringValue = "Restoring";
        private const string UpdatingValue = "Updating";
        private const string StoppingValue = "Stopping";
        private const string StoppedValue = "Stopped";
        private const string StartingValue = "Starting";
        private const string DBMovingValue = "DbMoving";
        private const string DBCopyingValue = "DbCopying";

        /// <summary> Online. </summary>
        public static ManagedDatabaseStatus Online { get; } = new ManagedDatabaseStatus(OnlineValue);
        /// <summary> Offline. </summary>
        public static ManagedDatabaseStatus Offline { get; } = new ManagedDatabaseStatus(OfflineValue);
        /// <summary> Shutdown. </summary>
        public static ManagedDatabaseStatus Shutdown { get; } = new ManagedDatabaseStatus(ShutdownValue);
        /// <summary> Creating. </summary>
        public static ManagedDatabaseStatus Creating { get; } = new ManagedDatabaseStatus(CreatingValue);
        /// <summary> Inaccessible. </summary>
        public static ManagedDatabaseStatus Inaccessible { get; } = new ManagedDatabaseStatus(InaccessibleValue);
        /// <summary> Restoring. </summary>
        public static ManagedDatabaseStatus Restoring { get; } = new ManagedDatabaseStatus(RestoringValue);
        /// <summary> Updating. </summary>
        public static ManagedDatabaseStatus Updating { get; } = new ManagedDatabaseStatus(UpdatingValue);
        /// <summary> Stopping. </summary>
        public static ManagedDatabaseStatus Stopping { get; } = new ManagedDatabaseStatus(StoppingValue);
        /// <summary> Stopped. </summary>
        public static ManagedDatabaseStatus Stopped { get; } = new ManagedDatabaseStatus(StoppedValue);
        /// <summary> Starting. </summary>
        public static ManagedDatabaseStatus Starting { get; } = new ManagedDatabaseStatus(StartingValue);
        /// <summary> DbMoving. </summary>
        public static ManagedDatabaseStatus DBMoving { get; } = new ManagedDatabaseStatus(DBMovingValue);
        /// <summary> DbCopying. </summary>
        public static ManagedDatabaseStatus DBCopying { get; } = new ManagedDatabaseStatus(DBCopyingValue);
        /// <summary> Determines if two <see cref="ManagedDatabaseStatus"/> values are the same. </summary>
        public static bool operator ==(ManagedDatabaseStatus left, ManagedDatabaseStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedDatabaseStatus"/> values are not the same. </summary>
        public static bool operator !=(ManagedDatabaseStatus left, ManagedDatabaseStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedDatabaseStatus"/>. </summary>
        public static implicit operator ManagedDatabaseStatus(string value) => new ManagedDatabaseStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedDatabaseStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedDatabaseStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
