// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The managed database's restore details backup set properties. </summary>
    public partial class ManagedDatabaseRestoreDetailBackupSetProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ManagedDatabaseRestoreDetailBackupSetProperties"/>. </summary>
        internal ManagedDatabaseRestoreDetailBackupSetProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ManagedDatabaseRestoreDetailBackupSetProperties"/>. </summary>
        /// <param name="status"> Backup set status. </param>
        /// <param name="firstStripeName"> First stripe name. </param>
        /// <param name="numberOfStripes"> Number of stripes. </param>
        /// <param name="backupSizeInMB"> Backup size. </param>
        /// <param name="restoreStartedOn"> Last restored file time. </param>
        /// <param name="restoreFinishedOn"> Last restored file time. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ManagedDatabaseRestoreDetailBackupSetProperties(string status, string firstStripeName, int? numberOfStripes, int? backupSizeInMB, DateTimeOffset? restoreStartedOn, DateTimeOffset? restoreFinishedOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            FirstStripeName = firstStripeName;
            NumberOfStripes = numberOfStripes;
            BackupSizeInMB = backupSizeInMB;
            RestoreStartedOn = restoreStartedOn;
            RestoreFinishedOn = restoreFinishedOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Backup set status. </summary>
        [WirePath("status")]
        public string Status { get; }
        /// <summary> First stripe name. </summary>
        [WirePath("firstStripeName")]
        public string FirstStripeName { get; }
        /// <summary> Number of stripes. </summary>
        [WirePath("numberOfStripes")]
        public int? NumberOfStripes { get; }
        /// <summary> Backup size. </summary>
        [WirePath("backupSizeMB")]
        public int? BackupSizeInMB { get; }
        /// <summary> Last restored file time. </summary>
        [WirePath("restoreStartedTimestampUtc")]
        public DateTimeOffset? RestoreStartedOn { get; }
        /// <summary> Last restored file time. </summary>
        [WirePath("restoreFinishedTimestampUtc")]
        public DateTimeOffset? RestoreFinishedOn { get; }
    }
}
