// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The type of the target. </summary>
    public readonly partial struct JobTargetType : IEquatable<JobTargetType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="JobTargetType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public JobTargetType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TargetGroupValue = "TargetGroup";
        private const string SqlDatabaseValue = "SqlDatabase";
        private const string SqlElasticPoolValue = "SqlElasticPool";
        private const string SqlShardMapValue = "SqlShardMap";
        private const string SqlServerValue = "SqlServer";

        /// <summary> TargetGroup. </summary>
        public static JobTargetType TargetGroup { get; } = new JobTargetType(TargetGroupValue);
        /// <summary> SqlDatabase. </summary>
        public static JobTargetType SqlDatabase { get; } = new JobTargetType(SqlDatabaseValue);
        /// <summary> SqlElasticPool. </summary>
        public static JobTargetType SqlElasticPool { get; } = new JobTargetType(SqlElasticPoolValue);
        /// <summary> SqlShardMap. </summary>
        public static JobTargetType SqlShardMap { get; } = new JobTargetType(SqlShardMapValue);
        /// <summary> SqlServer. </summary>
        public static JobTargetType SqlServer { get; } = new JobTargetType(SqlServerValue);
        /// <summary> Determines if two <see cref="JobTargetType"/> values are the same. </summary>
        public static bool operator ==(JobTargetType left, JobTargetType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="JobTargetType"/> values are not the same. </summary>
        public static bool operator !=(JobTargetType left, JobTargetType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="JobTargetType"/>. </summary>
        public static implicit operator JobTargetType(string value) => new JobTargetType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is JobTargetType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(JobTargetType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
