// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> Type of action being executed by the job step. </summary>
    public readonly partial struct JobStepActionType : IEquatable<JobStepActionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="JobStepActionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public JobStepActionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TSqlValue = "TSql";

        /// <summary> TSql. </summary>
        public static JobStepActionType TSql { get; } = new JobStepActionType(TSqlValue);
        /// <summary> Determines if two <see cref="JobStepActionType"/> values are the same. </summary>
        public static bool operator ==(JobStepActionType left, JobStepActionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="JobStepActionType"/> values are not the same. </summary>
        public static bool operator !=(JobStepActionType left, JobStepActionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="JobStepActionType"/>. </summary>
        public static implicit operator JobStepActionType(string value) => new JobStepActionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is JobStepActionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(JobStepActionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
