// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The source of the action to execute. </summary>
    public readonly partial struct JobStepActionSource : IEquatable<JobStepActionSource>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="JobStepActionSource"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public JobStepActionSource(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InlineValue = "Inline";

        /// <summary> Inline. </summary>
        public static JobStepActionSource Inline { get; } = new JobStepActionSource(InlineValue);
        /// <summary> Determines if two <see cref="JobStepActionSource"/> values are the same. </summary>
        public static bool operator ==(JobStepActionSource left, JobStepActionSource right) => left.Equals(right);
        /// <summary> Determines if two <see cref="JobStepActionSource"/> values are not the same. </summary>
        public static bool operator !=(JobStepActionSource left, JobStepActionSource right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="JobStepActionSource"/>. </summary>
        public static implicit operator JobStepActionSource(string value) => new JobStepActionSource(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is JobStepActionSource other && Equals(other);
        /// <inheritdoc />
        public bool Equals(JobStepActionSource other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
