// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The target that a job execution is executed on. </summary>
    public partial class JobExecutionTarget
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="JobExecutionTarget"/>. </summary>
        internal JobExecutionTarget()
        {
        }

        /// <summary> Initializes a new instance of <see cref="JobExecutionTarget"/>. </summary>
        /// <param name="targetType"> The type of the target. </param>
        /// <param name="serverName"> The server name. </param>
        /// <param name="databaseName"> The database name. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal JobExecutionTarget(JobTargetType? targetType, string serverName, string databaseName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TargetType = targetType;
            ServerName = serverName;
            DatabaseName = databaseName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The type of the target. </summary>
        [WirePath("type")]
        public JobTargetType? TargetType { get; }
        /// <summary> The server name. </summary>
        [WirePath("serverName")]
        public string ServerName { get; }
        /// <summary> The database name. </summary>
        [WirePath("databaseName")]
        public string DatabaseName { get; }
    }
}
