// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The detailed state of the job execution. </summary>
    public readonly partial struct JobExecutionLifecycle : IEquatable<JobExecutionLifecycle>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="JobExecutionLifecycle"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public JobExecutionLifecycle(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatedValue = "Created";
        private const string InProgressValue = "InProgress";
        private const string WaitingForChildJobExecutionsValue = "WaitingForChildJobExecutions";
        private const string WaitingForRetryValue = "WaitingForRetry";
        private const string SucceededValue = "Succeeded";
        private const string SucceededWithSkippedValue = "SucceededWithSkipped";
        private const string FailedValue = "Failed";
        private const string TimedOutValue = "TimedOut";
        private const string CanceledValue = "Canceled";
        private const string SkippedValue = "Skipped";

        /// <summary> Created. </summary>
        public static JobExecutionLifecycle Created { get; } = new JobExecutionLifecycle(CreatedValue);
        /// <summary> InProgress. </summary>
        public static JobExecutionLifecycle InProgress { get; } = new JobExecutionLifecycle(InProgressValue);
        /// <summary> WaitingForChildJobExecutions. </summary>
        public static JobExecutionLifecycle WaitingForChildJobExecutions { get; } = new JobExecutionLifecycle(WaitingForChildJobExecutionsValue);
        /// <summary> WaitingForRetry. </summary>
        public static JobExecutionLifecycle WaitingForRetry { get; } = new JobExecutionLifecycle(WaitingForRetryValue);
        /// <summary> Succeeded. </summary>
        public static JobExecutionLifecycle Succeeded { get; } = new JobExecutionLifecycle(SucceededValue);
        /// <summary> SucceededWithSkipped. </summary>
        public static JobExecutionLifecycle SucceededWithSkipped { get; } = new JobExecutionLifecycle(SucceededWithSkippedValue);
        /// <summary> Failed. </summary>
        public static JobExecutionLifecycle Failed { get; } = new JobExecutionLifecycle(FailedValue);
        /// <summary> TimedOut. </summary>
        public static JobExecutionLifecycle TimedOut { get; } = new JobExecutionLifecycle(TimedOutValue);
        /// <summary> Canceled. </summary>
        public static JobExecutionLifecycle Canceled { get; } = new JobExecutionLifecycle(CanceledValue);
        /// <summary> Skipped. </summary>
        public static JobExecutionLifecycle Skipped { get; } = new JobExecutionLifecycle(SkippedValue);
        /// <summary> Determines if two <see cref="JobExecutionLifecycle"/> values are the same. </summary>
        public static bool operator ==(JobExecutionLifecycle left, JobExecutionLifecycle right) => left.Equals(right);
        /// <summary> Determines if two <see cref="JobExecutionLifecycle"/> values are not the same. </summary>
        public static bool operator !=(JobExecutionLifecycle left, JobExecutionLifecycle right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="JobExecutionLifecycle"/>. </summary>
        public static implicit operator JobExecutionLifecycle(string value) => new JobExecutionLifecycle(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is JobExecutionLifecycle other && Equals(other);
        /// <inheritdoc />
        public bool Equals(JobExecutionLifecycle other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
