// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> An update to an Instance pool. </summary>
    public partial class InstancePoolPatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="InstancePoolPatch"/>. </summary>
        public InstancePoolPatch()
        {
            Tags = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="InstancePoolPatch"/>. </summary>
        /// <param name="sku"> The name and tier of the SKU. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="subnetId"> Resource ID of the subnet to place this instance pool in. </param>
        /// <param name="vCores"> Count of vCores belonging to this instance pool. </param>
        /// <param name="licenseType"> The license type. Possible values are 'LicenseIncluded' (price for SQL license is included) and 'BasePrice' (without SQL license price). </param>
        /// <param name="dnsZone"> The Dns Zone that the managed instance pool is in. </param>
        /// <param name="maintenanceConfigurationId"> Specifies maintenance configuration id to apply to this managed instance. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal InstancePoolPatch(SqlSku sku, IDictionary<string, string> tags, ResourceIdentifier subnetId, int? vCores, InstancePoolLicenseType? licenseType, string dnsZone, ResourceIdentifier maintenanceConfigurationId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Sku = sku;
            Tags = tags;
            SubnetId = subnetId;
            VCores = vCores;
            LicenseType = licenseType;
            DnsZone = dnsZone;
            MaintenanceConfigurationId = maintenanceConfigurationId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name and tier of the SKU. </summary>
        [WirePath("sku")]
        public SqlSku Sku { get; set; }
        /// <summary> Resource tags. </summary>
        [WirePath("tags")]
        public IDictionary<string, string> Tags { get; }
        /// <summary> Resource ID of the subnet to place this instance pool in. </summary>
        [WirePath("properties.subnetId")]
        public ResourceIdentifier SubnetId { get; set; }
        /// <summary> Count of vCores belonging to this instance pool. </summary>
        [WirePath("properties.vCores")]
        public int? VCores { get; set; }
        /// <summary> The license type. Possible values are 'LicenseIncluded' (price for SQL license is included) and 'BasePrice' (without SQL license price). </summary>
        [WirePath("properties.licenseType")]
        public InstancePoolLicenseType? LicenseType { get; set; }
        /// <summary> The Dns Zone that the managed instance pool is in. </summary>
        [WirePath("properties.dnsZone")]
        public string DnsZone { get; }
        /// <summary> Specifies maintenance configuration id to apply to this managed instance. </summary>
        [WirePath("properties.maintenanceConfigurationId")]
        public ResourceIdentifier MaintenanceConfigurationId { get; set; }
    }
}
