// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The instance pool family capability. </summary>
    public partial class InstancePoolFamilyCapability
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="InstancePoolFamilyCapability"/>. </summary>
        internal InstancePoolFamilyCapability()
        {
            SupportedLicenseTypes = new ChangeTrackingList<LicenseTypeCapability>();
            SupportedVcoresValues = new ChangeTrackingList<InstancePoolVcoresCapability>();
        }

        /// <summary> Initializes a new instance of <see cref="InstancePoolFamilyCapability"/>. </summary>
        /// <param name="name"> Family name. </param>
        /// <param name="supportedLicenseTypes"> List of supported license types. </param>
        /// <param name="supportedVcoresValues"> List of supported virtual cores values. </param>
        /// <param name="status"> The status of the capability. </param>
        /// <param name="reason"> The reason for the capability not being available. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal InstancePoolFamilyCapability(string name, IReadOnlyList<LicenseTypeCapability> supportedLicenseTypes, IReadOnlyList<InstancePoolVcoresCapability> supportedVcoresValues, SqlCapabilityStatus? status, string reason, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            SupportedLicenseTypes = supportedLicenseTypes;
            SupportedVcoresValues = supportedVcoresValues;
            Status = status;
            Reason = reason;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Family name. </summary>
        [WirePath("name")]
        public string Name { get; }
        /// <summary> List of supported license types. </summary>
        [WirePath("supportedLicenseTypes")]
        public IReadOnlyList<LicenseTypeCapability> SupportedLicenseTypes { get; }
        /// <summary> List of supported virtual cores values. </summary>
        [WirePath("supportedVcoresValues")]
        public IReadOnlyList<InstancePoolVcoresCapability> SupportedVcoresValues { get; }
        /// <summary> The status of the capability. </summary>
        [WirePath("status")]
        public SqlCapabilityStatus? Status { get; }
        /// <summary> The reason for the capability not being available. </summary>
        [WirePath("reason")]
        public string Reason { get; }
    }
}
