// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> Local replication role of the failover group instance. </summary>
    public readonly partial struct InstanceFailoverGroupReplicationRole : IEquatable<InstanceFailoverGroupReplicationRole>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="InstanceFailoverGroupReplicationRole"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public InstanceFailoverGroupReplicationRole(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PrimaryValue = "Primary";
        private const string SecondaryValue = "Secondary";

        /// <summary> Primary. </summary>
        public static InstanceFailoverGroupReplicationRole Primary { get; } = new InstanceFailoverGroupReplicationRole(PrimaryValue);
        /// <summary> Secondary. </summary>
        public static InstanceFailoverGroupReplicationRole Secondary { get; } = new InstanceFailoverGroupReplicationRole(SecondaryValue);
        /// <summary> Determines if two <see cref="InstanceFailoverGroupReplicationRole"/> values are the same. </summary>
        public static bool operator ==(InstanceFailoverGroupReplicationRole left, InstanceFailoverGroupReplicationRole right) => left.Equals(right);
        /// <summary> Determines if two <see cref="InstanceFailoverGroupReplicationRole"/> values are not the same. </summary>
        public static bool operator !=(InstanceFailoverGroupReplicationRole left, InstanceFailoverGroupReplicationRole right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="InstanceFailoverGroupReplicationRole"/>. </summary>
        public static implicit operator InstanceFailoverGroupReplicationRole(string value) => new InstanceFailoverGroupReplicationRole(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is InstanceFailoverGroupReplicationRole other && Equals(other);
        /// <inheritdoc />
        public bool Equals(InstanceFailoverGroupReplicationRole other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
