// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Sql.Models
{
    public partial class InstanceFailoverGroupReadWriteEndpoint : IUtf8JsonSerializable, IJsonModel<InstanceFailoverGroupReadWriteEndpoint>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<InstanceFailoverGroupReadWriteEndpoint>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<InstanceFailoverGroupReadWriteEndpoint>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InstanceFailoverGroupReadWriteEndpoint>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InstanceFailoverGroupReadWriteEndpoint)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("failoverPolicy"u8);
            writer.WriteStringValue(FailoverPolicy.ToString());
            if (Optional.IsDefined(FailoverWithDataLossGracePeriodMinutes))
            {
                writer.WritePropertyName("failoverWithDataLossGracePeriodMinutes"u8);
                writer.WriteNumberValue(FailoverWithDataLossGracePeriodMinutes.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        InstanceFailoverGroupReadWriteEndpoint IJsonModel<InstanceFailoverGroupReadWriteEndpoint>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InstanceFailoverGroupReadWriteEndpoint>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InstanceFailoverGroupReadWriteEndpoint)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeInstanceFailoverGroupReadWriteEndpoint(document.RootElement, options);
        }

        internal static InstanceFailoverGroupReadWriteEndpoint DeserializeInstanceFailoverGroupReadWriteEndpoint(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ReadWriteEndpointFailoverPolicy failoverPolicy = default;
            int? failoverWithDataLossGracePeriodMinutes = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("failoverPolicy"u8))
                {
                    failoverPolicy = new ReadWriteEndpointFailoverPolicy(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("failoverWithDataLossGracePeriodMinutes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    failoverWithDataLossGracePeriodMinutes = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new InstanceFailoverGroupReadWriteEndpoint(failoverPolicy, failoverWithDataLossGracePeriodMinutes, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FailoverPolicy), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  failoverPolicy: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  failoverPolicy: ");
                builder.AppendLine($"'{FailoverPolicy.ToString()}'");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FailoverWithDataLossGracePeriodMinutes), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  failoverWithDataLossGracePeriodMinutes: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(FailoverWithDataLossGracePeriodMinutes))
                {
                    builder.Append("  failoverWithDataLossGracePeriodMinutes: ");
                    builder.AppendLine($"{FailoverWithDataLossGracePeriodMinutes.Value}");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<InstanceFailoverGroupReadWriteEndpoint>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InstanceFailoverGroupReadWriteEndpoint>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(InstanceFailoverGroupReadWriteEndpoint)} does not support writing '{options.Format}' format.");
            }
        }

        InstanceFailoverGroupReadWriteEndpoint IPersistableModel<InstanceFailoverGroupReadWriteEndpoint>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InstanceFailoverGroupReadWriteEndpoint>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeInstanceFailoverGroupReadWriteEndpoint(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(InstanceFailoverGroupReadWriteEndpoint)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<InstanceFailoverGroupReadWriteEndpoint>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
