// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Sql.Models
{
    internal static partial class ImplementationMethodExtensions
    {
        public static string ToSerialString(this ImplementationMethod value) => value switch
        {
            ImplementationMethod.TSql => "TSql",
            ImplementationMethod.AzurePowerShell => "AzurePowerShell",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ImplementationMethod value.")
        };

        public static ImplementationMethod ToImplementationMethod(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "TSql")) return ImplementationMethod.TSql;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AzurePowerShell")) return ImplementationMethod.AzurePowerShell;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ImplementationMethod value.");
        }
    }
}
