// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> Type of the geo-secondary instance. Set 'Standby' if the instance is used as a DR option only. </summary>
    public readonly partial struct GeoSecondaryInstanceType : IEquatable<GeoSecondaryInstanceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GeoSecondaryInstanceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GeoSecondaryInstanceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string GeoValue = "Geo";
        private const string StandbyValue = "Standby";

        /// <summary> Geo. </summary>
        public static GeoSecondaryInstanceType Geo { get; } = new GeoSecondaryInstanceType(GeoValue);
        /// <summary> Standby. </summary>
        public static GeoSecondaryInstanceType Standby { get; } = new GeoSecondaryInstanceType(StandbyValue);
        /// <summary> Determines if two <see cref="GeoSecondaryInstanceType"/> values are the same. </summary>
        public static bool operator ==(GeoSecondaryInstanceType left, GeoSecondaryInstanceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GeoSecondaryInstanceType"/> values are not the same. </summary>
        public static bool operator !=(GeoSecondaryInstanceType left, GeoSecondaryInstanceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GeoSecondaryInstanceType"/>. </summary>
        public static implicit operator GeoSecondaryInstanceType(string value) => new GeoSecondaryInstanceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GeoSecondaryInstanceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GeoSecondaryInstanceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
