// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The GeoBackupPolicyName. </summary>
    public readonly partial struct GeoBackupPolicyName : IEquatable<GeoBackupPolicyName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GeoBackupPolicyName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GeoBackupPolicyName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "Default";

        /// <summary> Default. </summary>
        public static GeoBackupPolicyName Default { get; } = new GeoBackupPolicyName(DefaultValue);
        /// <summary> Determines if two <see cref="GeoBackupPolicyName"/> values are the same. </summary>
        public static bool operator ==(GeoBackupPolicyName left, GeoBackupPolicyName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GeoBackupPolicyName"/> values are not the same. </summary>
        public static bool operator !=(GeoBackupPolicyName left, GeoBackupPolicyName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GeoBackupPolicyName"/>. </summary>
        public static implicit operator GeoBackupPolicyName(string value) => new GeoBackupPolicyName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GeoBackupPolicyName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GeoBackupPolicyName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
