// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> Databases secondary type on partner server. </summary>
    public readonly partial struct FailoverGroupDatabasesSecondaryType : IEquatable<FailoverGroupDatabasesSecondaryType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FailoverGroupDatabasesSecondaryType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FailoverGroupDatabasesSecondaryType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string GeoValue = "Geo";
        private const string StandbyValue = "Standby";

        /// <summary> Geo. </summary>
        public static FailoverGroupDatabasesSecondaryType Geo { get; } = new FailoverGroupDatabasesSecondaryType(GeoValue);
        /// <summary> Standby. </summary>
        public static FailoverGroupDatabasesSecondaryType Standby { get; } = new FailoverGroupDatabasesSecondaryType(StandbyValue);
        /// <summary> Determines if two <see cref="FailoverGroupDatabasesSecondaryType"/> values are the same. </summary>
        public static bool operator ==(FailoverGroupDatabasesSecondaryType left, FailoverGroupDatabasesSecondaryType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FailoverGroupDatabasesSecondaryType"/> values are not the same. </summary>
        public static bool operator !=(FailoverGroupDatabasesSecondaryType left, FailoverGroupDatabasesSecondaryType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FailoverGroupDatabasesSecondaryType"/>. </summary>
        public static implicit operator FailoverGroupDatabasesSecondaryType(string value) => new FailoverGroupDatabasesSecondaryType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FailoverGroupDatabasesSecondaryType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FailoverGroupDatabasesSecondaryType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
