// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The state of the elastic pool. </summary>
    public readonly partial struct ElasticPoolState : IEquatable<ElasticPoolState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ElasticPoolState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ElasticPoolState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string ReadyValue = "Ready";
        private const string DisabledValue = "Disabled";

        /// <summary> Creating. </summary>
        public static ElasticPoolState Creating { get; } = new ElasticPoolState(CreatingValue);
        /// <summary> Ready. </summary>
        public static ElasticPoolState Ready { get; } = new ElasticPoolState(ReadyValue);
        /// <summary> Disabled. </summary>
        public static ElasticPoolState Disabled { get; } = new ElasticPoolState(DisabledValue);
        /// <summary> Determines if two <see cref="ElasticPoolState"/> values are the same. </summary>
        public static bool operator ==(ElasticPoolState left, ElasticPoolState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ElasticPoolState"/> values are not the same. </summary>
        public static bool operator !=(ElasticPoolState left, ElasticPoolState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ElasticPoolState"/>. </summary>
        public static implicit operator ElasticPoolState(string value) => new ElasticPoolState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ElasticPoolState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ElasticPoolState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
