// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The Elastic Pool performance level capability. </summary>
    public partial class ElasticPoolPerformanceLevelCapability
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ElasticPoolPerformanceLevelCapability"/>. </summary>
        internal ElasticPoolPerformanceLevelCapability()
        {
            SupportedLicenseTypes = new ChangeTrackingList<LicenseTypeCapability>();
            SupportedMaxSizes = new ChangeTrackingList<MaxSizeRangeCapability>();
            SupportedPerDatabaseMaxSizes = new ChangeTrackingList<MaxSizeRangeCapability>();
            SupportedPerDatabaseMaxPerformanceLevels = new ChangeTrackingList<ElasticPoolPerDatabaseMaxPerformanceLevelCapability>();
            SupportedMaintenanceConfigurations = new ChangeTrackingList<MaintenanceConfigurationCapability>();
        }

        /// <summary> Initializes a new instance of <see cref="ElasticPoolPerformanceLevelCapability"/>. </summary>
        /// <param name="performanceLevel"> The performance level for the pool. </param>
        /// <param name="sku"> The sku. </param>
        /// <param name="supportedLicenseTypes"> List of supported license types. </param>
        /// <param name="maxDatabaseCount"> The maximum number of databases supported. </param>
        /// <param name="includedMaxSize"> The included (free) max size for this performance level. </param>
        /// <param name="supportedMaxSizes"> The list of supported max sizes. </param>
        /// <param name="supportedPerDatabaseMaxSizes"> The list of supported per database max sizes. </param>
        /// <param name="supportedPerDatabaseMaxPerformanceLevels"> The list of supported per database max performance levels. </param>
        /// <param name="isZoneRedundant"> Whether or not zone redundancy is supported for the performance level. </param>
        /// <param name="supportedMaintenanceConfigurations"> List of supported maintenance configurations. </param>
        /// <param name="status"> The status of the capability. </param>
        /// <param name="reason"> The reason for the capability not being available. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ElasticPoolPerformanceLevelCapability(PerformanceLevelCapability performanceLevel, SqlSku sku, IReadOnlyList<LicenseTypeCapability> supportedLicenseTypes, int? maxDatabaseCount, MaxSizeCapability includedMaxSize, IReadOnlyList<MaxSizeRangeCapability> supportedMaxSizes, IReadOnlyList<MaxSizeRangeCapability> supportedPerDatabaseMaxSizes, IReadOnlyList<ElasticPoolPerDatabaseMaxPerformanceLevelCapability> supportedPerDatabaseMaxPerformanceLevels, bool? isZoneRedundant, IReadOnlyList<MaintenanceConfigurationCapability> supportedMaintenanceConfigurations, SqlCapabilityStatus? status, string reason, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PerformanceLevel = performanceLevel;
            Sku = sku;
            SupportedLicenseTypes = supportedLicenseTypes;
            MaxDatabaseCount = maxDatabaseCount;
            IncludedMaxSize = includedMaxSize;
            SupportedMaxSizes = supportedMaxSizes;
            SupportedPerDatabaseMaxSizes = supportedPerDatabaseMaxSizes;
            SupportedPerDatabaseMaxPerformanceLevels = supportedPerDatabaseMaxPerformanceLevels;
            IsZoneRedundant = isZoneRedundant;
            SupportedMaintenanceConfigurations = supportedMaintenanceConfigurations;
            Status = status;
            Reason = reason;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The performance level for the pool. </summary>
        [WirePath("performanceLevel")]
        public PerformanceLevelCapability PerformanceLevel { get; }
        /// <summary> The sku. </summary>
        [WirePath("sku")]
        public SqlSku Sku { get; }
        /// <summary> List of supported license types. </summary>
        [WirePath("supportedLicenseTypes")]
        public IReadOnlyList<LicenseTypeCapability> SupportedLicenseTypes { get; }
        /// <summary> The maximum number of databases supported. </summary>
        [WirePath("maxDatabaseCount")]
        public int? MaxDatabaseCount { get; }
        /// <summary> The included (free) max size for this performance level. </summary>
        [WirePath("includedMaxSize")]
        public MaxSizeCapability IncludedMaxSize { get; }
        /// <summary> The list of supported max sizes. </summary>
        [WirePath("supportedMaxSizes")]
        public IReadOnlyList<MaxSizeRangeCapability> SupportedMaxSizes { get; }
        /// <summary> The list of supported per database max sizes. </summary>
        [WirePath("supportedPerDatabaseMaxSizes")]
        public IReadOnlyList<MaxSizeRangeCapability> SupportedPerDatabaseMaxSizes { get; }
        /// <summary> The list of supported per database max performance levels. </summary>
        [WirePath("supportedPerDatabaseMaxPerformanceLevels")]
        public IReadOnlyList<ElasticPoolPerDatabaseMaxPerformanceLevelCapability> SupportedPerDatabaseMaxPerformanceLevels { get; }
        /// <summary> Whether or not zone redundancy is supported for the performance level. </summary>
        [WirePath("zoneRedundant")]
        public bool? IsZoneRedundant { get; }
        /// <summary> List of supported maintenance configurations. </summary>
        [WirePath("supportedMaintenanceConfigurations")]
        public IReadOnlyList<MaintenanceConfigurationCapability> SupportedMaintenanceConfigurations { get; }
        /// <summary> The status of the capability. </summary>
        [WirePath("status")]
        public SqlCapabilityStatus? Status { get; }
        /// <summary> The reason for the capability not being available. </summary>
        [WirePath("reason")]
        public string Reason { get; }
    }
}
