// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The max per-database performance level capability. </summary>
    public partial class ElasticPoolPerDatabaseMaxPerformanceLevelCapability
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ElasticPoolPerDatabaseMaxPerformanceLevelCapability"/>. </summary>
        internal ElasticPoolPerDatabaseMaxPerformanceLevelCapability()
        {
            SupportedPerDatabaseMinPerformanceLevels = new ChangeTrackingList<ElasticPoolPerDatabaseMinPerformanceLevelCapability>();
        }

        /// <summary> Initializes a new instance of <see cref="ElasticPoolPerDatabaseMaxPerformanceLevelCapability"/>. </summary>
        /// <param name="limit"> The maximum performance level per database. </param>
        /// <param name="unit"> Unit type used to measure performance level. </param>
        /// <param name="supportedPerDatabaseMinPerformanceLevels"> The list of supported min database performance levels. </param>
        /// <param name="status"> The status of the capability. </param>
        /// <param name="reason"> The reason for the capability not being available. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ElasticPoolPerDatabaseMaxPerformanceLevelCapability(double? limit, PerformanceLevelUnit? unit, IReadOnlyList<ElasticPoolPerDatabaseMinPerformanceLevelCapability> supportedPerDatabaseMinPerformanceLevels, SqlCapabilityStatus? status, string reason, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Limit = limit;
            Unit = unit;
            SupportedPerDatabaseMinPerformanceLevels = supportedPerDatabaseMinPerformanceLevels;
            Status = status;
            Reason = reason;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The maximum performance level per database. </summary>
        [WirePath("limit")]
        public double? Limit { get; }
        /// <summary> Unit type used to measure performance level. </summary>
        [WirePath("unit")]
        public PerformanceLevelUnit? Unit { get; }
        /// <summary> The list of supported min database performance levels. </summary>
        [WirePath("supportedPerDatabaseMinPerformanceLevels")]
        public IReadOnlyList<ElasticPoolPerDatabaseMinPerformanceLevelCapability> SupportedPerDatabaseMinPerformanceLevels { get; }
        /// <summary> The status of the capability. </summary>
        [WirePath("status")]
        public SqlCapabilityStatus? Status { get; }
        /// <summary> The reason for the capability not being available. </summary>
        [WirePath("reason")]
        public string Reason { get; }
    }
}
