// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The license type to apply for this elastic pool. </summary>
    public readonly partial struct ElasticPoolLicenseType : IEquatable<ElasticPoolLicenseType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ElasticPoolLicenseType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ElasticPoolLicenseType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LicenseIncludedValue = "LicenseIncluded";
        private const string BasePriceValue = "BasePrice";

        /// <summary> LicenseIncluded. </summary>
        public static ElasticPoolLicenseType LicenseIncluded { get; } = new ElasticPoolLicenseType(LicenseIncludedValue);
        /// <summary> BasePrice. </summary>
        public static ElasticPoolLicenseType BasePrice { get; } = new ElasticPoolLicenseType(BasePriceValue);
        /// <summary> Determines if two <see cref="ElasticPoolLicenseType"/> values are the same. </summary>
        public static bool operator ==(ElasticPoolLicenseType left, ElasticPoolLicenseType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ElasticPoolLicenseType"/> values are not the same. </summary>
        public static bool operator !=(ElasticPoolLicenseType left, ElasticPoolLicenseType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ElasticPoolLicenseType"/>. </summary>
        public static implicit operator ElasticPoolLicenseType(string value) => new ElasticPoolLicenseType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ElasticPoolLicenseType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ElasticPoolLicenseType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
