// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The status of the DNS refresh operation. </summary>
    public readonly partial struct DnsRefreshConfigurationPropertiesStatus : IEquatable<DnsRefreshConfigurationPropertiesStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DnsRefreshConfigurationPropertiesStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DnsRefreshConfigurationPropertiesStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string InProgressValue = "InProgress";

        /// <summary> Succeeded. </summary>
        public static DnsRefreshConfigurationPropertiesStatus Succeeded { get; } = new DnsRefreshConfigurationPropertiesStatus(SucceededValue);
        /// <summary> Failed. </summary>
        public static DnsRefreshConfigurationPropertiesStatus Failed { get; } = new DnsRefreshConfigurationPropertiesStatus(FailedValue);
        /// <summary> InProgress. </summary>
        public static DnsRefreshConfigurationPropertiesStatus InProgress { get; } = new DnsRefreshConfigurationPropertiesStatus(InProgressValue);
        /// <summary> Determines if two <see cref="DnsRefreshConfigurationPropertiesStatus"/> values are the same. </summary>
        public static bool operator ==(DnsRefreshConfigurationPropertiesStatus left, DnsRefreshConfigurationPropertiesStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DnsRefreshConfigurationPropertiesStatus"/> values are not the same. </summary>
        public static bool operator !=(DnsRefreshConfigurationPropertiesStatus left, DnsRefreshConfigurationPropertiesStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DnsRefreshConfigurationPropertiesStatus"/>. </summary>
        public static implicit operator DnsRefreshConfigurationPropertiesStatus(string value) => new DnsRefreshConfigurationPropertiesStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DnsRefreshConfigurationPropertiesStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DnsRefreshConfigurationPropertiesStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
