// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The license type to apply for this database. `LicenseIncluded` if you need a license, or `BasePrice` if you have a license and are eligible for the Azure Hybrid Benefit. </summary>
    public readonly partial struct DatabaseLicenseType : IEquatable<DatabaseLicenseType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DatabaseLicenseType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DatabaseLicenseType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LicenseIncludedValue = "LicenseIncluded";
        private const string BasePriceValue = "BasePrice";

        /// <summary> LicenseIncluded. </summary>
        public static DatabaseLicenseType LicenseIncluded { get; } = new DatabaseLicenseType(LicenseIncludedValue);
        /// <summary> BasePrice. </summary>
        public static DatabaseLicenseType BasePrice { get; } = new DatabaseLicenseType(BasePriceValue);
        /// <summary> Determines if two <see cref="DatabaseLicenseType"/> values are the same. </summary>
        public static bool operator ==(DatabaseLicenseType left, DatabaseLicenseType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DatabaseLicenseType"/> values are not the same. </summary>
        public static bool operator !=(DatabaseLicenseType left, DatabaseLicenseType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DatabaseLicenseType"/>. </summary>
        public static implicit operator DatabaseLicenseType(string value) => new DatabaseLicenseType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DatabaseLicenseType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DatabaseLicenseType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
