// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> Operation Mode. </summary>
    public readonly partial struct DatabaseExtensionOperationMode : IEquatable<DatabaseExtensionOperationMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DatabaseExtensionOperationMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DatabaseExtensionOperationMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PolybaseImportValue = "PolybaseImport";

        /// <summary> PolybaseImport. </summary>
        public static DatabaseExtensionOperationMode PolybaseImport { get; } = new DatabaseExtensionOperationMode(PolybaseImportValue);
        /// <summary> Determines if two <see cref="DatabaseExtensionOperationMode"/> values are the same. </summary>
        public static bool operator ==(DatabaseExtensionOperationMode left, DatabaseExtensionOperationMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DatabaseExtensionOperationMode"/> values are not the same. </summary>
        public static bool operator !=(DatabaseExtensionOperationMode left, DatabaseExtensionOperationMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DatabaseExtensionOperationMode"/>. </summary>
        public static implicit operator DatabaseExtensionOperationMode(string value) => new DatabaseExtensionOperationMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DatabaseExtensionOperationMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DatabaseExtensionOperationMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
