// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Sql.Models
{
    internal static partial class DataMaskingStateExtensions
    {
        public static string ToSerialString(this DataMaskingState value) => value switch
        {
            DataMaskingState.Disabled => "Disabled",
            DataMaskingState.Enabled => "Enabled",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataMaskingState value.")
        };

        public static DataMaskingState ToDataMaskingState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Disabled")) return DataMaskingState.Disabled;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Enabled")) return DataMaskingState.Enabled;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataMaskingState value.");
        }
    }
}
