// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The ConnectionPolicyName. </summary>
    public readonly partial struct ConnectionPolicyName : IEquatable<ConnectionPolicyName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConnectionPolicyName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConnectionPolicyName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "default";

        /// <summary> default. </summary>
        public static ConnectionPolicyName Default { get; } = new ConnectionPolicyName(DefaultValue);
        /// <summary> Determines if two <see cref="ConnectionPolicyName"/> values are the same. </summary>
        public static bool operator ==(ConnectionPolicyName left, ConnectionPolicyName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConnectionPolicyName"/> values are not the same. </summary>
        public static bool operator !=(ConnectionPolicyName left, ConnectionPolicyName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConnectionPolicyName"/>. </summary>
        public static implicit operator ConnectionPolicyName(string value) => new ConnectionPolicyName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConnectionPolicyName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConnectionPolicyName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
