// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> Contains the information necessary to change long term retention backup access tier and related operation mode. </summary>
    public partial class ChangeLongTermRetentionBackupAccessTierParameters
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ChangeLongTermRetentionBackupAccessTierParameters"/>. </summary>
        /// <param name="backupStorageAccessTier"> The long term retention backup storage access tier. </param>
        /// <param name="operationMode"> The operation mode when updating ltr backup storage access tier. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="backupStorageAccessTier"/> or <paramref name="operationMode"/> is null. </exception>
        public ChangeLongTermRetentionBackupAccessTierParameters(string backupStorageAccessTier, string operationMode)
        {
            Argument.AssertNotNull(backupStorageAccessTier, nameof(backupStorageAccessTier));
            Argument.AssertNotNull(operationMode, nameof(operationMode));

            BackupStorageAccessTier = backupStorageAccessTier;
            OperationMode = operationMode;
        }

        /// <summary> Initializes a new instance of <see cref="ChangeLongTermRetentionBackupAccessTierParameters"/>. </summary>
        /// <param name="backupStorageAccessTier"> The long term retention backup storage access tier. </param>
        /// <param name="operationMode"> The operation mode when updating ltr backup storage access tier. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ChangeLongTermRetentionBackupAccessTierParameters(string backupStorageAccessTier, string operationMode, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BackupStorageAccessTier = backupStorageAccessTier;
            OperationMode = operationMode;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ChangeLongTermRetentionBackupAccessTierParameters"/> for deserialization. </summary>
        internal ChangeLongTermRetentionBackupAccessTierParameters()
        {
        }

        /// <summary> The long term retention backup storage access tier. </summary>
        [WirePath("backupStorageAccessTier")]
        public string BackupStorageAccessTier { get; }
        /// <summary> The operation mode when updating ltr backup storage access tier. </summary>
        [WirePath("operationMode")]
        public string OperationMode { get; }
    }
}
