// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Sql.Models
{
    public partial class ChangeLongTermRetentionBackupAccessTierParameters : IUtf8JsonSerializable, IJsonModel<ChangeLongTermRetentionBackupAccessTierParameters>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ChangeLongTermRetentionBackupAccessTierParameters>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ChangeLongTermRetentionBackupAccessTierParameters>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ChangeLongTermRetentionBackupAccessTierParameters>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ChangeLongTermRetentionBackupAccessTierParameters)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("backupStorageAccessTier"u8);
            writer.WriteStringValue(BackupStorageAccessTier);
            writer.WritePropertyName("operationMode"u8);
            writer.WriteStringValue(OperationMode);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ChangeLongTermRetentionBackupAccessTierParameters IJsonModel<ChangeLongTermRetentionBackupAccessTierParameters>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ChangeLongTermRetentionBackupAccessTierParameters>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ChangeLongTermRetentionBackupAccessTierParameters)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeChangeLongTermRetentionBackupAccessTierParameters(document.RootElement, options);
        }

        internal static ChangeLongTermRetentionBackupAccessTierParameters DeserializeChangeLongTermRetentionBackupAccessTierParameters(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string backupStorageAccessTier = default;
            string operationMode = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("backupStorageAccessTier"u8))
                {
                    backupStorageAccessTier = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("operationMode"u8))
                {
                    operationMode = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ChangeLongTermRetentionBackupAccessTierParameters(backupStorageAccessTier, operationMode, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ChangeLongTermRetentionBackupAccessTierParameters>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ChangeLongTermRetentionBackupAccessTierParameters>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ChangeLongTermRetentionBackupAccessTierParameters)} does not support writing '{options.Format}' format.");
            }
        }

        ChangeLongTermRetentionBackupAccessTierParameters IPersistableModel<ChangeLongTermRetentionBackupAccessTierParameters>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ChangeLongTermRetentionBackupAccessTierParameters>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeChangeLongTermRetentionBackupAccessTierParameters(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ChangeLongTermRetentionBackupAccessTierParameters)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ChangeLongTermRetentionBackupAccessTierParameters>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
