// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> Collation of the metadata catalog. </summary>
    public readonly partial struct CatalogCollationType : IEquatable<CatalogCollationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CatalogCollationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CatalogCollationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DatabaseDefaultValue = "DATABASE_DEFAULT";
        private const string SqlLatin1GeneralCp1CiAsValue = "SQL_Latin1_General_CP1_CI_AS";

        /// <summary> DATABASE_DEFAULT. </summary>
        public static CatalogCollationType DatabaseDefault { get; } = new CatalogCollationType(DatabaseDefaultValue);
        /// <summary> SQL_Latin1_General_CP1_CI_AS. </summary>
        public static CatalogCollationType SqlLatin1GeneralCp1CiAs { get; } = new CatalogCollationType(SqlLatin1GeneralCp1CiAsValue);
        /// <summary> Determines if two <see cref="CatalogCollationType"/> values are the same. </summary>
        public static bool operator ==(CatalogCollationType left, CatalogCollationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CatalogCollationType"/> values are not the same. </summary>
        public static bool operator !=(CatalogCollationType left, CatalogCollationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CatalogCollationType"/>. </summary>
        public static implicit operator CatalogCollationType(string value) => new CatalogCollationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CatalogCollationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CatalogCollationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
