// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Sql.Models
{
    internal static partial class AutomaticTuningServerReasonExtensions
    {
        public static string ToSerialString(this AutomaticTuningServerReason value) => value switch
        {
            AutomaticTuningServerReason.Default => "Default",
            AutomaticTuningServerReason.Disabled => "Disabled",
            AutomaticTuningServerReason.AutoConfigured => "AutoConfigured",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AutomaticTuningServerReason value.")
        };

        public static AutomaticTuningServerReason ToAutomaticTuningServerReason(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Default")) return AutomaticTuningServerReason.Default;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Disabled")) return AutomaticTuningServerReason.Disabled;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AutoConfigured")) return AutomaticTuningServerReason.AutoConfigured;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AutomaticTuningServerReason value.");
        }
    }
}
