// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> Automatic tuning properties for individual advisors. </summary>
    public partial class AutomaticTuningServerOptions
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AutomaticTuningServerOptions"/>. </summary>
        public AutomaticTuningServerOptions()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AutomaticTuningServerOptions"/>. </summary>
        /// <param name="desiredState"> Automatic tuning option desired state. </param>
        /// <param name="actualState"> Automatic tuning option actual state. </param>
        /// <param name="reasonCode"> Reason code if desired and actual state are different. </param>
        /// <param name="reasonDesc"> Reason description if desired and actual state are different. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AutomaticTuningServerOptions(AutomaticTuningOptionModeDesired? desiredState, AutomaticTuningOptionModeActual? actualState, int? reasonCode, AutomaticTuningServerReason? reasonDesc, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DesiredState = desiredState;
            ActualState = actualState;
            ReasonCode = reasonCode;
            ReasonDesc = reasonDesc;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Automatic tuning option desired state. </summary>
        [WirePath("desiredState")]
        public AutomaticTuningOptionModeDesired? DesiredState { get; set; }
        /// <summary> Automatic tuning option actual state. </summary>
        [WirePath("actualState")]
        public AutomaticTuningOptionModeActual? ActualState { get; }
        /// <summary> Reason code if desired and actual state are different. </summary>
        [WirePath("reasonCode")]
        public int? ReasonCode { get; }
        /// <summary> Reason description if desired and actual state are different. </summary>
        [WirePath("reasonDesc")]
        public AutomaticTuningServerReason? ReasonDesc { get; }
    }
}
