// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Sql.Models
{
    internal static partial class AutomaticTuningModeExtensions
    {
        public static string ToSerialString(this AutomaticTuningMode value) => value switch
        {
            AutomaticTuningMode.Unspecified => "Unspecified",
            AutomaticTuningMode.Inherit => "Inherit",
            AutomaticTuningMode.Custom => "Custom",
            AutomaticTuningMode.Auto => "Auto",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AutomaticTuningMode value.")
        };

        public static AutomaticTuningMode ToAutomaticTuningMode(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Unspecified")) return AutomaticTuningMode.Unspecified;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Inherit")) return AutomaticTuningMode.Inherit;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Custom")) return AutomaticTuningMode.Custom;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Auto")) return AutomaticTuningMode.Auto;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AutomaticTuningMode value.");
        }
    }
}
