// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Sql.Models
{
    internal static partial class AutomaticTuningDisabledReasonExtensions
    {
        public static string ToSerialString(this AutomaticTuningDisabledReason value) => value switch
        {
            AutomaticTuningDisabledReason.Default => "Default",
            AutomaticTuningDisabledReason.Disabled => "Disabled",
            AutomaticTuningDisabledReason.AutoConfigured => "AutoConfigured",
            AutomaticTuningDisabledReason.InheritedFromServer => "InheritedFromServer",
            AutomaticTuningDisabledReason.QueryStoreOff => "QueryStoreOff",
            AutomaticTuningDisabledReason.QueryStoreReadOnly => "QueryStoreReadOnly",
            AutomaticTuningDisabledReason.NotSupported => "NotSupported",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AutomaticTuningDisabledReason value.")
        };

        public static AutomaticTuningDisabledReason ToAutomaticTuningDisabledReason(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Default")) return AutomaticTuningDisabledReason.Default;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Disabled")) return AutomaticTuningDisabledReason.Disabled;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AutoConfigured")) return AutomaticTuningDisabledReason.AutoConfigured;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "InheritedFromServer")) return AutomaticTuningDisabledReason.InheritedFromServer;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "QueryStoreOff")) return AutomaticTuningDisabledReason.QueryStoreOff;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "QueryStoreReadOnly")) return AutomaticTuningDisabledReason.QueryStoreReadOnly;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NotSupported")) return AutomaticTuningDisabledReason.NotSupported;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AutomaticTuningDisabledReason value.");
        }
    }
}
