// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Sql.Models
{
    internal static partial class AutoExecuteStatusExtensions
    {
        public static string ToSerialString(this AutoExecuteStatus value) => value switch
        {
            AutoExecuteStatus.Default => "Default",
            AutoExecuteStatus.Enabled => "Enabled",
            AutoExecuteStatus.Disabled => "Disabled",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AutoExecuteStatus value.")
        };

        public static AutoExecuteStatus ToAutoExecuteStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Default")) return AutoExecuteStatus.Default;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Enabled")) return AutoExecuteStatus.Enabled;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Disabled")) return AutoExecuteStatus.Disabled;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AutoExecuteStatus value.");
        }
    }
}
