// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Sql.Models
{
    internal static partial class AdvancedThreatProtectionStateExtensions
    {
        public static string ToSerialString(this AdvancedThreatProtectionState value) => value switch
        {
            AdvancedThreatProtectionState.New => "New",
            AdvancedThreatProtectionState.Enabled => "Enabled",
            AdvancedThreatProtectionState.Disabled => "Disabled",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AdvancedThreatProtectionState value.")
        };

        public static AdvancedThreatProtectionState ToAdvancedThreatProtectionState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "New")) return AdvancedThreatProtectionState.New;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Enabled")) return AdvancedThreatProtectionState.Enabled;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Disabled")) return AdvancedThreatProtectionState.Disabled;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown AdvancedThreatProtectionState value.");
        }
    }
}
