// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Sql.Models
{
    internal static partial class ActionRetryableStateExtensions
    {
        public static string ToSerialString(this ActionRetryableState value) => value switch
        {
            ActionRetryableState.Yes => "Yes",
            ActionRetryableState.No => "No",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ActionRetryableState value.")
        };

        public static ActionRetryableState ToActionRetryableState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Yes")) return ActionRetryableState.Yes;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "No")) return ActionRetryableState.No;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ActionRetryableState value.");
        }
    }
}
