// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A class representing the ManagedInstanceStartStopSchedule data model.
    /// Managed instance's Start/Stop schedule.
    /// </summary>
    public partial class ManagedInstanceStartStopScheduleData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ManagedInstanceStartStopScheduleData"/>. </summary>
        public ManagedInstanceStartStopScheduleData()
        {
            ScheduleList = new ChangeTrackingList<SqlScheduleItem>();
        }

        /// <summary> Initializes a new instance of <see cref="ManagedInstanceStartStopScheduleData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> The description of the schedule. </param>
        /// <param name="timeZoneId"> The time zone of the schedule. </param>
        /// <param name="scheduleList"> Schedule list. </param>
        /// <param name="nextRunAction"> Next action to be executed (Start or Stop). </param>
        /// <param name="nextExecutionTime"> Timestamp when the next action will be executed in the corresponding schedule time zone. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ManagedInstanceStartStopScheduleData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string description, string timeZoneId, IList<SqlScheduleItem> scheduleList, string nextRunAction, string nextExecutionTime, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Description = description;
            TimeZoneId = timeZoneId;
            ScheduleList = scheduleList;
            NextRunAction = nextRunAction;
            NextExecutionTime = nextExecutionTime;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The description of the schedule. </summary>
        [WirePath("properties.description")]
        public string Description { get; set; }
        /// <summary> The time zone of the schedule. </summary>
        [WirePath("properties.timeZoneId")]
        public string TimeZoneId { get; set; }
        /// <summary> Schedule list. </summary>
        [WirePath("properties.scheduleList")]
        public IList<SqlScheduleItem> ScheduleList { get; }
        /// <summary> Next action to be executed (Start or Stop). </summary>
        [WirePath("properties.nextRunAction")]
        public string NextRunAction { get; }
        /// <summary> Timestamp when the next action will be executed in the corresponding schedule time zone. </summary>
        [WirePath("properties.nextExecutionTime")]
        public string NextExecutionTime { get; }
    }
}
