// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A class representing a collection of <see cref="ManagedDatabaseVulnerabilityAssessmentScanResource"/> and their operations.
    /// Each <see cref="ManagedDatabaseVulnerabilityAssessmentScanResource"/> in the collection will belong to the same instance of <see cref="ManagedDatabaseVulnerabilityAssessmentResource"/>.
    /// To get a <see cref="ManagedDatabaseVulnerabilityAssessmentScanCollection"/> instance call the GetManagedDatabaseVulnerabilityAssessmentScans method from an instance of <see cref="ManagedDatabaseVulnerabilityAssessmentResource"/>.
    /// </summary>
    public partial class ManagedDatabaseVulnerabilityAssessmentScanCollection : ArmCollection, IEnumerable<ManagedDatabaseVulnerabilityAssessmentScanResource>, IAsyncEnumerable<ManagedDatabaseVulnerabilityAssessmentScanResource>
    {
        private readonly ClientDiagnostics _managedDatabaseVulnerabilityAssessmentScanClientDiagnostics;
        private readonly ManagedDatabaseVulnerabilityAssessmentScansRestOperations _managedDatabaseVulnerabilityAssessmentScanRestClient;

        /// <summary> Initializes a new instance of the <see cref="ManagedDatabaseVulnerabilityAssessmentScanCollection"/> class for mocking. </summary>
        protected ManagedDatabaseVulnerabilityAssessmentScanCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ManagedDatabaseVulnerabilityAssessmentScanCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal ManagedDatabaseVulnerabilityAssessmentScanCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _managedDatabaseVulnerabilityAssessmentScanClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Sql", ManagedDatabaseVulnerabilityAssessmentScanResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ManagedDatabaseVulnerabilityAssessmentScanResource.ResourceType, out string managedDatabaseVulnerabilityAssessmentScanApiVersion);
            _managedDatabaseVulnerabilityAssessmentScanRestClient = new ManagedDatabaseVulnerabilityAssessmentScansRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, managedDatabaseVulnerabilityAssessmentScanApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ManagedDatabaseVulnerabilityAssessmentResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ManagedDatabaseVulnerabilityAssessmentResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets a vulnerability assessment scan record of a database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagedDatabaseVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ManagedDatabaseVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The vulnerability assessment scan Id of the scan to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual async Task<Response<ManagedDatabaseVulnerabilityAssessmentScanResource>> GetAsync(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _managedDatabaseVulnerabilityAssessmentScanClientDiagnostics.CreateScope("ManagedDatabaseVulnerabilityAssessmentScanCollection.Get");
            scope.Start();
            try
            {
                var response = await _managedDatabaseVulnerabilityAssessmentScanRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ManagedDatabaseVulnerabilityAssessmentScanResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a vulnerability assessment scan record of a database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagedDatabaseVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ManagedDatabaseVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The vulnerability assessment scan Id of the scan to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual Response<ManagedDatabaseVulnerabilityAssessmentScanResource> Get(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _managedDatabaseVulnerabilityAssessmentScanClientDiagnostics.CreateScope("ManagedDatabaseVulnerabilityAssessmentScanCollection.Get");
            scope.Start();
            try
            {
                var response = _managedDatabaseVulnerabilityAssessmentScanRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ManagedDatabaseVulnerabilityAssessmentScanResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists the vulnerability assessment scans of a database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagedDatabaseVulnerabilityAssessmentScans_ListByDatabase</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ManagedDatabaseVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ManagedDatabaseVulnerabilityAssessmentScanResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ManagedDatabaseVulnerabilityAssessmentScanResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _managedDatabaseVulnerabilityAssessmentScanRestClient.CreateListByDatabaseRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _managedDatabaseVulnerabilityAssessmentScanRestClient.CreateListByDatabaseNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new ManagedDatabaseVulnerabilityAssessmentScanResource(Client, VulnerabilityAssessmentScanRecordData.DeserializeVulnerabilityAssessmentScanRecordData(e)), _managedDatabaseVulnerabilityAssessmentScanClientDiagnostics, Pipeline, "ManagedDatabaseVulnerabilityAssessmentScanCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the vulnerability assessment scans of a database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagedDatabaseVulnerabilityAssessmentScans_ListByDatabase</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ManagedDatabaseVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ManagedDatabaseVulnerabilityAssessmentScanResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ManagedDatabaseVulnerabilityAssessmentScanResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _managedDatabaseVulnerabilityAssessmentScanRestClient.CreateListByDatabaseRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _managedDatabaseVulnerabilityAssessmentScanRestClient.CreateListByDatabaseNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new ManagedDatabaseVulnerabilityAssessmentScanResource(Client, VulnerabilityAssessmentScanRecordData.DeserializeVulnerabilityAssessmentScanRecordData(e)), _managedDatabaseVulnerabilityAssessmentScanClientDiagnostics, Pipeline, "ManagedDatabaseVulnerabilityAssessmentScanCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagedDatabaseVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ManagedDatabaseVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The vulnerability assessment scan Id of the scan to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _managedDatabaseVulnerabilityAssessmentScanClientDiagnostics.CreateScope("ManagedDatabaseVulnerabilityAssessmentScanCollection.Exists");
            scope.Start();
            try
            {
                var response = await _managedDatabaseVulnerabilityAssessmentScanRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagedDatabaseVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ManagedDatabaseVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The vulnerability assessment scan Id of the scan to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual Response<bool> Exists(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _managedDatabaseVulnerabilityAssessmentScanClientDiagnostics.CreateScope("ManagedDatabaseVulnerabilityAssessmentScanCollection.Exists");
            scope.Start();
            try
            {
                var response = _managedDatabaseVulnerabilityAssessmentScanRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagedDatabaseVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ManagedDatabaseVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The vulnerability assessment scan Id of the scan to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual async Task<NullableResponse<ManagedDatabaseVulnerabilityAssessmentScanResource>> GetIfExistsAsync(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _managedDatabaseVulnerabilityAssessmentScanClientDiagnostics.CreateScope("ManagedDatabaseVulnerabilityAssessmentScanCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _managedDatabaseVulnerabilityAssessmentScanRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<ManagedDatabaseVulnerabilityAssessmentScanResource>(response.GetRawResponse());
                return Response.FromValue(new ManagedDatabaseVulnerabilityAssessmentScanResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagedDatabaseVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ManagedDatabaseVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The vulnerability assessment scan Id of the scan to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual NullableResponse<ManagedDatabaseVulnerabilityAssessmentScanResource> GetIfExists(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _managedDatabaseVulnerabilityAssessmentScanClientDiagnostics.CreateScope("ManagedDatabaseVulnerabilityAssessmentScanCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _managedDatabaseVulnerabilityAssessmentScanRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<ManagedDatabaseVulnerabilityAssessmentScanResource>(response.GetRawResponse());
                return Response.FromValue(new ManagedDatabaseVulnerabilityAssessmentScanResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<ManagedDatabaseVulnerabilityAssessmentScanResource> IEnumerable<ManagedDatabaseVulnerabilityAssessmentScanResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<ManagedDatabaseVulnerabilityAssessmentScanResource> IAsyncEnumerable<ManagedDatabaseVulnerabilityAssessmentScanResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
