// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    public partial class ManagedDatabaseRestoreDetailData : IUtf8JsonSerializable, IJsonModel<ManagedDatabaseRestoreDetailData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ManagedDatabaseRestoreDetailData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ManagedDatabaseRestoreDetailData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ManagedDatabaseRestoreDetailData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ManagedDatabaseRestoreDetailData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(RestoreType))
            {
                writer.WritePropertyName("type"u8);
                writer.WriteStringValue(RestoreType);
            }
            if (options.Format != "W" && Optional.IsDefined(Status))
            {
                writer.WritePropertyName("status"u8);
                writer.WriteStringValue(Status);
            }
            if (options.Format != "W" && Optional.IsDefined(BlockReason))
            {
                writer.WritePropertyName("blockReason"u8);
                writer.WriteStringValue(BlockReason);
            }
            if (options.Format != "W" && Optional.IsDefined(LastUploadedFileName))
            {
                writer.WritePropertyName("lastUploadedFileName"u8);
                writer.WriteStringValue(LastUploadedFileName);
            }
            if (options.Format != "W" && Optional.IsDefined(LastUploadedFileOn))
            {
                writer.WritePropertyName("lastUploadedFileTime"u8);
                writer.WriteStringValue(LastUploadedFileOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(LastRestoredFileName))
            {
                writer.WritePropertyName("lastRestoredFileName"u8);
                writer.WriteStringValue(LastRestoredFileName);
            }
            if (options.Format != "W" && Optional.IsDefined(LastRestoredFileOn))
            {
                writer.WritePropertyName("lastRestoredFileTime"u8);
                writer.WriteStringValue(LastRestoredFileOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(CompletedPercent))
            {
                writer.WritePropertyName("percentCompleted"u8);
                writer.WriteNumberValue(CompletedPercent.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(CurrentRestoredSizeInMB))
            {
                writer.WritePropertyName("currentRestoredSizeMB"u8);
                writer.WriteNumberValue(CurrentRestoredSizeInMB.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(CurrentRestorePlanSizeInMB))
            {
                writer.WritePropertyName("currentRestorePlanSizeMB"u8);
                writer.WriteNumberValue(CurrentRestorePlanSizeInMB.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(CurrentBackupType))
            {
                writer.WritePropertyName("currentBackupType"u8);
                writer.WriteStringValue(CurrentBackupType);
            }
            if (options.Format != "W" && Optional.IsDefined(CurrentRestoringFileName))
            {
                writer.WritePropertyName("currentRestoringFileName"u8);
                writer.WriteStringValue(CurrentRestoringFileName);
            }
            if (options.Format != "W" && Optional.IsDefined(NumberOfFilesFound))
            {
                writer.WritePropertyName("numberOfFilesDetected"u8);
                writer.WriteNumberValue(NumberOfFilesFound.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(NumberOfFilesQueued))
            {
                writer.WritePropertyName("numberOfFilesQueued"u8);
                writer.WriteNumberValue(NumberOfFilesQueued.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(NumberOfFilesSkipped))
            {
                writer.WritePropertyName("numberOfFilesSkipped"u8);
                writer.WriteNumberValue(NumberOfFilesSkipped.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(NumberOfFilesRestoring))
            {
                writer.WritePropertyName("numberOfFilesRestoring"u8);
                writer.WriteNumberValue(NumberOfFilesRestoring.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(NumberOfFilesRestored))
            {
                writer.WritePropertyName("numberOfFilesRestored"u8);
                writer.WriteNumberValue(NumberOfFilesRestored.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(NumberOfFilesUnrestorable))
            {
                writer.WritePropertyName("numberOfFilesUnrestorable"u8);
                writer.WriteNumberValue(NumberOfFilesUnrestorable.Value);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(FullBackupSets))
            {
                writer.WritePropertyName("fullBackupSets"u8);
                writer.WriteStartArray();
                foreach (var item in FullBackupSets)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(DiffBackupSets))
            {
                writer.WritePropertyName("diffBackupSets"u8);
                writer.WriteStartArray();
                foreach (var item in DiffBackupSets)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(LogBackupSets))
            {
                writer.WritePropertyName("logBackupSets"u8);
                writer.WriteStartArray();
                foreach (var item in LogBackupSets)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(UnrestorableFileList))
            {
                writer.WritePropertyName("unrestorableFiles"u8);
                writer.WriteStartArray();
                foreach (var item in UnrestorableFileList)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
        }

        ManagedDatabaseRestoreDetailData IJsonModel<ManagedDatabaseRestoreDetailData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ManagedDatabaseRestoreDetailData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ManagedDatabaseRestoreDetailData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeManagedDatabaseRestoreDetailData(document.RootElement, options);
        }

        internal static ManagedDatabaseRestoreDetailData DeserializeManagedDatabaseRestoreDetailData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string type0 = default;
            string status = default;
            string blockReason = default;
            string lastUploadedFileName = default;
            DateTimeOffset? lastUploadedFileTime = default;
            string lastRestoredFileName = default;
            DateTimeOffset? lastRestoredFileTime = default;
            int? percentCompleted = default;
            int? currentRestoredSizeMB = default;
            int? currentRestorePlanSizeMB = default;
            string currentBackupType = default;
            string currentRestoringFileName = default;
            int? numberOfFilesDetected = default;
            int? numberOfFilesQueued = default;
            int? numberOfFilesSkipped = default;
            int? numberOfFilesRestoring = default;
            int? numberOfFilesRestored = default;
            int? numberOfFilesUnrestorable = default;
            IReadOnlyList<ManagedDatabaseRestoreDetailBackupSetProperties> fullBackupSets = default;
            IReadOnlyList<ManagedDatabaseRestoreDetailBackupSetProperties> diffBackupSets = default;
            IReadOnlyList<ManagedDatabaseRestoreDetailBackupSetProperties> logBackupSets = default;
            IReadOnlyList<ManagedDatabaseRestoreDetailUnrestorableFileProperties> unrestorableFiles = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("type"u8))
                        {
                            type0 = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("status"u8))
                        {
                            status = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("blockReason"u8))
                        {
                            blockReason = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("lastUploadedFileName"u8))
                        {
                            lastUploadedFileName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("lastUploadedFileTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            lastUploadedFileTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("lastRestoredFileName"u8))
                        {
                            lastRestoredFileName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("lastRestoredFileTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            lastRestoredFileTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("percentCompleted"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            percentCompleted = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("currentRestoredSizeMB"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            currentRestoredSizeMB = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("currentRestorePlanSizeMB"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            currentRestorePlanSizeMB = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("currentBackupType"u8))
                        {
                            currentBackupType = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("currentRestoringFileName"u8))
                        {
                            currentRestoringFileName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("numberOfFilesDetected"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            numberOfFilesDetected = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("numberOfFilesQueued"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            numberOfFilesQueued = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("numberOfFilesSkipped"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            numberOfFilesSkipped = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("numberOfFilesRestoring"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            numberOfFilesRestoring = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("numberOfFilesRestored"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            numberOfFilesRestored = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("numberOfFilesUnrestorable"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            numberOfFilesUnrestorable = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("fullBackupSets"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ManagedDatabaseRestoreDetailBackupSetProperties> array = new List<ManagedDatabaseRestoreDetailBackupSetProperties>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ManagedDatabaseRestoreDetailBackupSetProperties.DeserializeManagedDatabaseRestoreDetailBackupSetProperties(item, options));
                            }
                            fullBackupSets = array;
                            continue;
                        }
                        if (property0.NameEquals("diffBackupSets"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ManagedDatabaseRestoreDetailBackupSetProperties> array = new List<ManagedDatabaseRestoreDetailBackupSetProperties>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ManagedDatabaseRestoreDetailBackupSetProperties.DeserializeManagedDatabaseRestoreDetailBackupSetProperties(item, options));
                            }
                            diffBackupSets = array;
                            continue;
                        }
                        if (property0.NameEquals("logBackupSets"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ManagedDatabaseRestoreDetailBackupSetProperties> array = new List<ManagedDatabaseRestoreDetailBackupSetProperties>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ManagedDatabaseRestoreDetailBackupSetProperties.DeserializeManagedDatabaseRestoreDetailBackupSetProperties(item, options));
                            }
                            logBackupSets = array;
                            continue;
                        }
                        if (property0.NameEquals("unrestorableFiles"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ManagedDatabaseRestoreDetailUnrestorableFileProperties> array = new List<ManagedDatabaseRestoreDetailUnrestorableFileProperties>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ManagedDatabaseRestoreDetailUnrestorableFileProperties.DeserializeManagedDatabaseRestoreDetailUnrestorableFileProperties(item, options));
                            }
                            unrestorableFiles = array;
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ManagedDatabaseRestoreDetailData(
                id,
                name,
                type,
                systemData,
                type0,
                status,
                blockReason,
                lastUploadedFileName,
                lastUploadedFileTime,
                lastRestoredFileName,
                lastRestoredFileTime,
                percentCompleted,
                currentRestoredSizeMB,
                currentRestorePlanSizeMB,
                currentBackupType,
                currentRestoringFileName,
                numberOfFilesDetected,
                numberOfFilesQueued,
                numberOfFilesSkipped,
                numberOfFilesRestoring,
                numberOfFilesRestored,
                numberOfFilesUnrestorable,
                fullBackupSets ?? new ChangeTrackingList<ManagedDatabaseRestoreDetailBackupSetProperties>(),
                diffBackupSets ?? new ChangeTrackingList<ManagedDatabaseRestoreDetailBackupSetProperties>(),
                logBackupSets ?? new ChangeTrackingList<ManagedDatabaseRestoreDetailBackupSetProperties>(),
                unrestorableFiles ?? new ChangeTrackingList<ManagedDatabaseRestoreDetailUnrestorableFileProperties>(),
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RestoreType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    type: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RestoreType))
                {
                    builder.Append("    type: ");
                    if (RestoreType.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{RestoreType}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{RestoreType}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Status), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    status: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Status))
                {
                    builder.Append("    status: ");
                    if (Status.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Status}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Status}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BlockReason), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    blockReason: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BlockReason))
                {
                    builder.Append("    blockReason: ");
                    if (BlockReason.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{BlockReason}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{BlockReason}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LastUploadedFileName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    lastUploadedFileName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LastUploadedFileName))
                {
                    builder.Append("    lastUploadedFileName: ");
                    if (LastUploadedFileName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{LastUploadedFileName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{LastUploadedFileName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LastUploadedFileOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    lastUploadedFileTime: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LastUploadedFileOn))
                {
                    builder.Append("    lastUploadedFileTime: ");
                    var formattedDateTimeString = TypeFormatters.ToString(LastUploadedFileOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LastRestoredFileName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    lastRestoredFileName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LastRestoredFileName))
                {
                    builder.Append("    lastRestoredFileName: ");
                    if (LastRestoredFileName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{LastRestoredFileName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{LastRestoredFileName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LastRestoredFileOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    lastRestoredFileTime: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LastRestoredFileOn))
                {
                    builder.Append("    lastRestoredFileTime: ");
                    var formattedDateTimeString = TypeFormatters.ToString(LastRestoredFileOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CompletedPercent), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    percentCompleted: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CompletedPercent))
                {
                    builder.Append("    percentCompleted: ");
                    builder.AppendLine($"{CompletedPercent.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CurrentRestoredSizeInMB), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    currentRestoredSizeMB: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CurrentRestoredSizeInMB))
                {
                    builder.Append("    currentRestoredSizeMB: ");
                    builder.AppendLine($"{CurrentRestoredSizeInMB.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CurrentRestorePlanSizeInMB), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    currentRestorePlanSizeMB: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CurrentRestorePlanSizeInMB))
                {
                    builder.Append("    currentRestorePlanSizeMB: ");
                    builder.AppendLine($"{CurrentRestorePlanSizeInMB.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CurrentBackupType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    currentBackupType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CurrentBackupType))
                {
                    builder.Append("    currentBackupType: ");
                    if (CurrentBackupType.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{CurrentBackupType}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{CurrentBackupType}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CurrentRestoringFileName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    currentRestoringFileName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CurrentRestoringFileName))
                {
                    builder.Append("    currentRestoringFileName: ");
                    if (CurrentRestoringFileName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{CurrentRestoringFileName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{CurrentRestoringFileName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NumberOfFilesFound), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    numberOfFilesDetected: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NumberOfFilesFound))
                {
                    builder.Append("    numberOfFilesDetected: ");
                    builder.AppendLine($"{NumberOfFilesFound.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NumberOfFilesQueued), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    numberOfFilesQueued: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NumberOfFilesQueued))
                {
                    builder.Append("    numberOfFilesQueued: ");
                    builder.AppendLine($"{NumberOfFilesQueued.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NumberOfFilesSkipped), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    numberOfFilesSkipped: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NumberOfFilesSkipped))
                {
                    builder.Append("    numberOfFilesSkipped: ");
                    builder.AppendLine($"{NumberOfFilesSkipped.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NumberOfFilesRestoring), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    numberOfFilesRestoring: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NumberOfFilesRestoring))
                {
                    builder.Append("    numberOfFilesRestoring: ");
                    builder.AppendLine($"{NumberOfFilesRestoring.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NumberOfFilesRestored), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    numberOfFilesRestored: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NumberOfFilesRestored))
                {
                    builder.Append("    numberOfFilesRestored: ");
                    builder.AppendLine($"{NumberOfFilesRestored.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NumberOfFilesUnrestorable), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    numberOfFilesUnrestorable: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NumberOfFilesUnrestorable))
                {
                    builder.Append("    numberOfFilesUnrestorable: ");
                    builder.AppendLine($"{NumberOfFilesUnrestorable.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FullBackupSets), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    fullBackupSets: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(FullBackupSets))
                {
                    if (FullBackupSets.Any())
                    {
                        builder.Append("    fullBackupSets: ");
                        builder.AppendLine("[");
                        foreach (var item in FullBackupSets)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    fullBackupSets: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DiffBackupSets), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    diffBackupSets: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(DiffBackupSets))
                {
                    if (DiffBackupSets.Any())
                    {
                        builder.Append("    diffBackupSets: ");
                        builder.AppendLine("[");
                        foreach (var item in DiffBackupSets)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    diffBackupSets: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LogBackupSets), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    logBackupSets: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(LogBackupSets))
                {
                    if (LogBackupSets.Any())
                    {
                        builder.Append("    logBackupSets: ");
                        builder.AppendLine("[");
                        foreach (var item in LogBackupSets)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    logBackupSets: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(UnrestorableFileList), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    unrestorableFiles: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(UnrestorableFileList))
                {
                    if (UnrestorableFileList.Any())
                    {
                        builder.Append("    unrestorableFiles: ");
                        builder.AppendLine("[");
                        foreach (var item in UnrestorableFileList)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    unrestorableFiles: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<ManagedDatabaseRestoreDetailData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ManagedDatabaseRestoreDetailData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(ManagedDatabaseRestoreDetailData)} does not support writing '{options.Format}' format.");
            }
        }

        ManagedDatabaseRestoreDetailData IPersistableModel<ManagedDatabaseRestoreDetailData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ManagedDatabaseRestoreDetailData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeManagedDatabaseRestoreDetailData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ManagedDatabaseRestoreDetailData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ManagedDatabaseRestoreDetailData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
