// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A class representing a collection of <see cref="ManagedDatabaseRestoreDetailResource"/> and their operations.
    /// Each <see cref="ManagedDatabaseRestoreDetailResource"/> in the collection will belong to the same instance of <see cref="ManagedDatabaseResource"/>.
    /// To get a <see cref="ManagedDatabaseRestoreDetailCollection"/> instance call the GetManagedDatabaseRestoreDetails method from an instance of <see cref="ManagedDatabaseResource"/>.
    /// </summary>
    public partial class ManagedDatabaseRestoreDetailCollection : ArmCollection
    {
        private readonly ClientDiagnostics _managedDatabaseRestoreDetailClientDiagnostics;
        private readonly ManagedDatabaseRestoreDetailsRestOperations _managedDatabaseRestoreDetailRestClient;

        /// <summary> Initializes a new instance of the <see cref="ManagedDatabaseRestoreDetailCollection"/> class for mocking. </summary>
        protected ManagedDatabaseRestoreDetailCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ManagedDatabaseRestoreDetailCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal ManagedDatabaseRestoreDetailCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _managedDatabaseRestoreDetailClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Sql", ManagedDatabaseRestoreDetailResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ManagedDatabaseRestoreDetailResource.ResourceType, out string managedDatabaseRestoreDetailApiVersion);
            _managedDatabaseRestoreDetailRestClient = new ManagedDatabaseRestoreDetailsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, managedDatabaseRestoreDetailApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ManagedDatabaseResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ManagedDatabaseResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets managed database restore details.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/restoreDetails/{restoreDetailsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagedDatabaseRestoreDetails_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-05-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ManagedDatabaseRestoreDetailResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="restoreDetailsName"> The name of the restore details to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<ManagedDatabaseRestoreDetailResource>> GetAsync(RestoreDetailsName restoreDetailsName, CancellationToken cancellationToken = default)
        {
            using var scope = _managedDatabaseRestoreDetailClientDiagnostics.CreateScope("ManagedDatabaseRestoreDetailCollection.Get");
            scope.Start();
            try
            {
                var response = await _managedDatabaseRestoreDetailRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, restoreDetailsName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ManagedDatabaseRestoreDetailResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets managed database restore details.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/restoreDetails/{restoreDetailsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagedDatabaseRestoreDetails_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-05-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ManagedDatabaseRestoreDetailResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="restoreDetailsName"> The name of the restore details to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<ManagedDatabaseRestoreDetailResource> Get(RestoreDetailsName restoreDetailsName, CancellationToken cancellationToken = default)
        {
            using var scope = _managedDatabaseRestoreDetailClientDiagnostics.CreateScope("ManagedDatabaseRestoreDetailCollection.Get");
            scope.Start();
            try
            {
                var response = _managedDatabaseRestoreDetailRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, restoreDetailsName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ManagedDatabaseRestoreDetailResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/restoreDetails/{restoreDetailsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagedDatabaseRestoreDetails_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-05-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ManagedDatabaseRestoreDetailResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="restoreDetailsName"> The name of the restore details to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<bool>> ExistsAsync(RestoreDetailsName restoreDetailsName, CancellationToken cancellationToken = default)
        {
            using var scope = _managedDatabaseRestoreDetailClientDiagnostics.CreateScope("ManagedDatabaseRestoreDetailCollection.Exists");
            scope.Start();
            try
            {
                var response = await _managedDatabaseRestoreDetailRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, restoreDetailsName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/restoreDetails/{restoreDetailsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagedDatabaseRestoreDetails_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-05-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ManagedDatabaseRestoreDetailResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="restoreDetailsName"> The name of the restore details to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<bool> Exists(RestoreDetailsName restoreDetailsName, CancellationToken cancellationToken = default)
        {
            using var scope = _managedDatabaseRestoreDetailClientDiagnostics.CreateScope("ManagedDatabaseRestoreDetailCollection.Exists");
            scope.Start();
            try
            {
                var response = _managedDatabaseRestoreDetailRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, restoreDetailsName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/restoreDetails/{restoreDetailsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagedDatabaseRestoreDetails_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-05-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ManagedDatabaseRestoreDetailResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="restoreDetailsName"> The name of the restore details to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<NullableResponse<ManagedDatabaseRestoreDetailResource>> GetIfExistsAsync(RestoreDetailsName restoreDetailsName, CancellationToken cancellationToken = default)
        {
            using var scope = _managedDatabaseRestoreDetailClientDiagnostics.CreateScope("ManagedDatabaseRestoreDetailCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _managedDatabaseRestoreDetailRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, restoreDetailsName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<ManagedDatabaseRestoreDetailResource>(response.GetRawResponse());
                return Response.FromValue(new ManagedDatabaseRestoreDetailResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/restoreDetails/{restoreDetailsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagedDatabaseRestoreDetails_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-05-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ManagedDatabaseRestoreDetailResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="restoreDetailsName"> The name of the restore details to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual NullableResponse<ManagedDatabaseRestoreDetailResource> GetIfExists(RestoreDetailsName restoreDetailsName, CancellationToken cancellationToken = default)
        {
            using var scope = _managedDatabaseRestoreDetailClientDiagnostics.CreateScope("ManagedDatabaseRestoreDetailCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _managedDatabaseRestoreDetailRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, restoreDetailsName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<ManagedDatabaseRestoreDetailResource>(response.GetRawResponse());
                return Response.FromValue(new ManagedDatabaseRestoreDetailResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
